#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#include <GDIPlus.au3>
#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>

AutoItSetOption("GUIOnEventMode", 1)
_GDIPlus_Startup()

Global Const $iW = 500, $iH = 500, $sTitle = "Sphere v1 / FPS: "
Global Const $hGUI = GUICreate($sTitle & 0, $iW, $iH)
GUISetState()
Global Const $hDC = _WinAPI_GetDC($hGUI)
Global Const $hHBitmap = _WinAPI_CreateCompatibleBitmap($hDC, $iW, $iH)
Global Const $hDC_backbuffer = _WinAPI_CreateCompatibleDC($hDC)
Global Const $DC_obj = _WinAPI_SelectObject($hDC_backbuffer, $hHBitmap)
Global Const $hCanvas = _GDIPlus_GraphicsCreateFromHDC($hDC_backbuffer)
_GDIPlus_GraphicsSetPixelOffsetMode($hCanvas, 4)
_GDIPlus_GraphicsSetSmoothingMode($hCanvas, 4)
_GDIPlus_GraphicsClear($hCanvas)
Global Const $hBrush = _GDIPlus_BrushCreateSolid(0xFFFFFFFF)
Global Const $fPi = ACos(-1), $fRad = $fPi / 180, $iWh = $iW / 2, $iHh = $iH / 2
Global $i, $iFPS = 0, $iDots = 350, $fSphereRadius = 200, $aDots[$iDots][3], $fTheta, $fRho, $fPhi, $iX, $iY, $iZ, _
	   $fXAngle = 0, $fYAngle = 0, $fZAngle = 0

;create sphere (https://de.wikipedia.org/wiki/Kugelkoordinaten)
For $i = 0 To $iDots - 1
	$fTheta = $i / $iDots * 28 * $fPi
	$fRho = ($i / $iDots) * ($i / $iDots)
	If $fRho < 1 Then
		$fPhi = 2 * Sqrt($fRho) * $fPi * 0.5
	Else
		$fPhi = (2 - Sqrt(2 - $fRho)) * $fPi * 0.5
	EndIf
	$aDots[$i][0] = $fSphereRadius * Sin($fPhi) * Cos($fTheta)
	$aDots[$i][1] = $fSphereRadius * Cos($fPhi)
	$aDots[$i][2] = $fSphereRadius * Sin($fPhi) * Sin($fTheta)
Next



GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit")
AdlibRegister("CalcFPS", 1000)

Do
	_GDIPlus_GraphicsClear($hCanvas, 0xFF000000)
	For $i = 0 To $iDots - 1
		_3Dto2D($aDots[$i][0], $aDots[$i][1], $aDots[$i][2], $fXAngle, $fYAngle, $fZAngle, $iX, $iY)
		_GDIPlus_GraphicsFillRect($hCanvas, $iWh + $iX, $iHh + $iY, 2, 2, $hBrush)
	Next
	$fXAngle += 1
;~ 	$fYAngle += 1.25
	$fZAngle -= 0.75
	_WinAPI_BitBlt($hDC, 0, 0, $iW, $iH, $hDC_backbuffer, 0, 0, $SRCCOPY)
	$iFPS += 1
Until Not Sleep(10)

Func _Exit()
	AdlibUnRegister("CalcFPS")
	_GDIPlus_BrushDispose($hBrush)
	_GDIPlus_GraphicsDispose($hCanvas)
	_WinAPI_SelectObject($hDC, $DC_obj)
	_WinAPI_DeleteObject($hHBitmap)
	_WinAPI_ReleaseDC($hGUI, $hDC)
	_GDIPlus_Shutdown()
	GUIDelete()
	Exit
EndFunc

Func CalcFPS()
	WinSetTitle($hGUI, "", $sTitle & $iFPS)
	$iFPS = 0
EndFunc

Func _3Dto2D($fX, $fY, $fZ, $fRotX, $fRotY, $fRotZ, ByRef $fXPos, ByRef $fYPos)
	;apply the x-axis rotation to transform coordinates ($fX, $fY, $fZ) into coordinates ($fX0, $fY0, $fZ0)
	Local Const $fX0 = $fX
	Local Const $fY0 = $fY * Cos($fRotX * $fRad) + $fZ * Sin($fRotX * $fRad)
	Local Const $fZ0 = $fZ * Cos($fRotX * $fRad) - $fY * Sin($fRotX * $fRad)

	;apply the y-axis rotation to ($fX0, $fY0, $fZ0) to obtain ($fX1, $fY1, $fZ1)
	Local Const $fX1 = $fX0 * Cos($fRotY * $fRad) - $fZ0 * Sin($fRotY * $fRad)
	Local Const $fY1 = $fY0
	Local Const $fZ1 = $fZ0 * Cos($fRotY * $fRad) + $fX0 * Cos($fRotY * $fRad)

	;finally, apply the z-axis rotation to obtain the point ($fXPos, $fYPos)
	$fXPos = $fX1 * Cos($fRotZ * $fRad) + $fY1 * Sin($fRotZ * $fRad)
	$fYPos = $fY1 * Cos($fRotZ * $fRad) - $fX1 * Sin($fRotZ * $fRad)
EndFunc